<?php

use Illuminate\Database\Capsule\Manager as Capsule;

if (!defined("WHMCS"))
	die("This file cannot be accessed directly");

/*
************************************************

*** FraudRecord Addon Module FOR WHMCS 6.x 7.x ***
*** Module Version 0.7.0
*** Main Module File

FraudRecord is a free service for online service providers (hosting companies or others), designed to help them combine their knowledge and combat against misbehaving clients. Companies can report unpleasant clients to FraudRecord, and access our database to read the information provided by other companies. 

Visit http://www.fraudrecord.com/ for more information.

************************************************
*/

function fraudrecord_config() {
    $configarray = array(
    "name" => "FraudRecord",
    "description" => "Allows integration with FraudRecord system, so that you can report and query about problematic or disruptive clients.",
    "version" => "1.0",
    "author" => "FraudRecord.com",
    "language" => "english",
    "fields" => array(
		 "option1" => array ("FriendlyName" => "API Code", "Type" => "text", "Size" => "18", "Description" => "API code for your reporter profile. Obtained from FraudRecord website, under 'Reporter Profiles'.", "Default" => "", ),
		
    ));
    return $configarray;
}

function fraudrecord_activate() {
	
	/**
	 * @var PDO $pdo
	 */
	$pdo = Capsule::connection()->getPdo();
	
    # Create Custom DB Table
	$result = $pdo->query("CREATE TABLE IF NOT EXISTS `mod_fraudrecord` (
			  `ID_FRC` int(11) NOT NULL AUTO_INCREMENT,
			  `ID_CLIENT` int(11) NOT NULL,
			  `report_value` int(11) NOT NULL,
			  `report_type` VARCHAR(32) NOT NULL,
			  `report_data` text NOT NULL,
			  `report_time` int(11) NOT NULL,
			  `report_code` varchar(16) NOT NULL,
			  `report_adminid` int(11) NOT NULL,
			  `query_value` varchar(32) NOT NULL,
			  `query_time` int(11) NOT NULL,
			  PRIMARY KEY (`ID_FRC`)
			)");

	# Return Result
	if($result == true)
	{
		// reserve first entry
		$pdo->query("DELETE FROM mod_fraudrecord WHERE ID_FRC = 1");
		$pdo->query("INSERT INTO mod_fraudrecord (ID_FRC, ID_CLIENT, report_data) VALUES (1,0,'')");
		
		return array('status'=>'success','description'=>'Addon successfully activated. Scroll below and provide your "API Code", and activate access to administrators and sales operators.');
	}
    else
		return array('status'=>'error','description'=>'There was a problem activating the module.');

}

function fraudrecord_deactivate() {

	/**
	 * @var PDO $pdo
	 */
	$pdo = Capsule::connection()->getPdo();
	
	$result = $pdo->query("DROP TABLE `mod_fraudrecord`");

    # Return Result
	if($result == true)
		return array('status'=>'success','description'=>'Addon successfully removed.');
	else
		return array('status'=>'error','description'=>'There was a problem removing the addon.');
}

function fraudrecord_upgrade($vars) {

    $version = $vars['version'];
}

function fraudrecord_output($vars)
{
	global $frc_error;
	$frc_error = array();
	
	/**
	 * @var PDO $pdo
	 */
	$pdo = Capsule::connection()->getPdo();
	
	$adminid = $_SESSION['adminid'];
    $modulelink = $vars['modulelink'];
    $version = $vars['version'];
    $apicode = trim($vars['option1']);
    
    $LANG = $vars['_lang'];
	/**/
	
	
	$action = $_REQUEST['action'];
	$clientid = (int) $_REQUEST['clientid'];
	
	if($action == 'report')
	{
		$display = 'report';
		
		if($clientid > 0)
			$client = frc_get_client_details($clientid);		
		
		if(isset($_POST['submit']) && !empty($client))
		{
			// cleanup htmlspecialchars from whmcs inputs
			
			foreach($_POST as $k => $v)
				if(!is_array($v))
					$_POST[$k] = htmlspecialchars_decode($v);
			
			// test some fields
			if(empty($_POST['text']))
				$frc_error[] = $LANG['emptytext'];
			if(empty($_POST['type']))
				$frc_error[] = $LANG['emptytype'];
			elseif(strlen($_POST['type']) < 1 || strlen($_POST['type']) > 32)
				$frc_error[] = $LANG['typelength'];
			if(empty($_POST['value']) || !ctype_digit($_POST['value']) || $_POST['value'] < 1 || $_POST['value'] > 10)
				$frc_error[] = $LANG['invalidvalue'];
			
			// no errors?			
			if(empty($frc_error))
			{
				// define fields
				$fields = array(
					'_api' => $apicode,
					'_action' => 'report',
					'_text' => $_POST['text'],
					'_type' => strtolower($_POST['type']),
					'_value' => (int) $_POST['value'],
				);
				
				// add hashed fields
				foreach($client as $k => $v)
					if(isset($_POST[$k.'_check']) && prepare_value($v) != "")
						$fields[$k] = fraudrecord_hash(prepare_value($v));
				
				// add some more fields if the admin adds them manually
				$extra = array();
				foreach($_POST as $k => $v)
				{
					if(!empty($v) && prepare_value($v) != "" && substr($k,0,3) == "key")
					{
						$n = substr($k,3);
						// trim any whitespace and underscore from "key".
						$extra[] = array(trim(trim($_POST['key'.$n]),"_"),$_POST['value'.$n]);
					}
				}
				foreach($extra as $x)
				{
					if(!empty($x[1]) && trim($x[1]) != "")
					{
						// make sure each field is unique. if email and email1 is defined alread, make sure we add email2.
						$c = '';
						while(isset($fields[$x[0].$c]))
							$c = ((int)$c)+1;
						if($c)
							$x[0] = $x[0].$c;
							
						// still make sure not to overwrite
						if(empty($fields[$x[0]]))
							$fields[$x[0]] = fraudrecord_hash(prepare_value($x[1]));
					}
				}
				
				//open connection
				$ch = curl_init();

				//set the url, number of POST vars, POST data
				curl_setopt($ch,CURLOPT_URL,"https://www.fraudrecord.com/api/");
				curl_setopt($ch,CURLOPT_POST,count($fields));
				curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
				curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);

				//execute post
				$result = curl_exec($ch);

				//close connection
				curl_close($ch);
				
				if(preg_match("~OK:([0-9a-z]{16})~",$result, $response) && !empty($response[1]))
				{
					$responsecode = $response[1];
					
					$insert = array(
						'ID_CLIENT' => $clientid,
						'report_value' => $fields['_value'],
						'report_type' => $fields['_type'],
						'report_data' => base64_encode(serialize($fields)),
						'report_time' => time(),
						'report_code' => $responsecode,
						'report_adminid' => $adminid,
					);
					Capsule::table("mod_fraudrecord")->insert($insert);
					
					$status = "success";					
					$display = 'list';
					$action = 'list';
				}
				else
				{
					$frc_error[] = $LANG['reporterror'];
					
					$f = @fopen(dirname(__FILE__)."/fraudrecord.log","a");
					@fwrite($f,"Date:".date("d.m.Y H:i:s")."\n".$result."\n\n------\n\n");
					@fclose($f);
				}
			}
		}
		else
		{
			
		}
		
	}
	if($action == 'query')
	{
		$display = 'query';
		
		if($clientid > 0)
			$client = frc_get_client_details($clientid);		
		
		if(isset($_POST['submit']) && !empty($client))
		{
				// define fields
				$fields = array(
					'_api' => $apicode,
					'_action' => 'query',
				);
				
				// add hashed fields
				foreach($client as $k => $v)
					if(isset($_POST[$k.'_check']) && prepare_value($v) != "")
						$fields[$k] = fraudrecord_hash(prepare_value($v));
				
				// add some more fields if the admin adds them manually
				$extra = array();
				foreach($_POST as $k => $v)
				{
					if(!empty($v) && prepare_value($v) != "" && substr($k,0,3) == "key")
					{
						$n = substr($k,3);
						// trim any whitespace and underscore from "key".
						$extra[] = array(trim(trim($_POST['key'.$n]),"_"),$_POST['value'.$n]);
					}
				}
				foreach($extra as $x)
				{
					if(!empty($x[1]) && trim($x[1]) != "")
					{
						// make sure each field is unique. if email and email1 is defined alread, make sure we add email2.
						$c = '';
						while(isset($fields[$x[0].$c]))
							$c = ((int)$c)+1;
						if($c)
							$x[0] = $x[0].$c;
							
						// still make sure not to overwrite
						if(empty($fields[$x[0]]))
							$fields[$x[0]] = fraudrecord_hash(prepare_value($x[1]));
					}
				}
				
				//open connection
				$ch = curl_init();

				//set the url, number of POST vars, POST data
				curl_setopt($ch,CURLOPT_URL,"https://www.fraudrecord.com/api/");
				curl_setopt($ch,CURLOPT_POST,count($fields));
				curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
				curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);

				//execute post
				$result = curl_exec($ch);

				//close connection
				curl_close($ch);
				
				preg_match("~\<report\>([0-9.\-a-f]+)\</report\>~",$result,$matches);
	
				$result_exp = explode("-",$matches[1]);
				$query_value = $matches[1];
				if(isset($result_exp[3]) && strlen($result_exp[3]) == 16)
				{
					
				
					// is the client in the mod_fraudrecord already?
					$result = $pdo->query("
					SELECT MIN(ID_FRC) as minid
					FROM mod_fraudrecord
					WHERE ID_CLIENT = $clientid");
					$minid = $result->fetch(PDO::FETCH_ASSOC);
					
					$minid = $minid['minid'];
					
					if(!empty($minid))
					{
						
						$update = array(
							"query_value"=>$query_value,
							"query_time" => time(),
						);
						
						Capsule::table("mod_fraudrecord")->where("ID_FRC", $minid)->update($update);
					}
					else
					{
						$insert = array(
							'ID_CLIENT' => $clientid,
							"query_value"=>$query_value,
							"query_time" => time(),
						);
						Capsule::table("mod_fraudrecord")->insert($insert);
					}
					
					$status = "successquery";					
					$display = 'displayquery';
					$action = 'query';
				}
				else
				{					
					$frc_error[] = $LANG['queryerror'];
					
					$f = @fopen(dirname(__FILE__)."/fraudrecord.log","a");
					@fwrite($f,"Date:".date("d.m.Y H:i:s")."\n".$result."\n\n------\n\n");
					@fclose($f);
				}
		}
	}
	
	if($action == 'details')
	{
		$display = 'details';
		
		// get client details
		$result = $pdo->query("
		SELECT frc.*, cl.firstname, cl.lastname, cl.email
		FROM mod_fraudrecord as frc
			LEFT JOIN tblclients as cl ON cl.id = frc.ID_CLIENT
		WHERE ID_CLIENT = $clientid
		");
		
		$reports = array();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			if($row['report_value'] > 0)
				$reports[] = $row;
		}
		
	}
	if($action == 'delete')
	{
		$reportid = (int) $_REQUEST['reportid'];		
		
		// get report code from id
		$result = $pdo->query("
		SELECT report_code
		FROM mod_fraudrecord
		WHERE ID_FRC = '$reportid'
		");
		
		$reportcode = $result->fetch(PDO::FETCH_ASSOC);
		$reportcode = $reportcode['report_code'];
		
		// define fields
		$fields = array(
			'_api' => $apicode,
			'_action' => 'delete',
			'_code' => $reportcode,
		);
		
		//open connection
		$ch = curl_init();

		//set the url, number of POST vars, POST data
		curl_setopt($ch,CURLOPT_URL,"https://www.fraudrecord.com/api/");
		curl_setopt($ch,CURLOPT_POST,count($fields));
		curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);

		//execute post
		$result = curl_exec($ch);

		//close connection
		curl_close($ch);
		
		// delete from own DB
		$result = $pdo->query("
		UPDATE mod_fraudrecord
		SET report_value = 0, report_type = '', report_data = '', report_time = 0, report_adminid = 0, report_code = 0
		WHERE ID_FRC = '$reportid'
		");
		
		
		$status = "successdelete";					
		$display = 'list';
		$action = 'list';
	}
	
	if(empty($action) && isset($_POST['checkbutton']))
	{
		@set_time_limit(0);
		$checked = array();
	
		foreach($_POST as $k => $v)
		{
			if(strpos($k,"check_") === 0 && ctype_digit(substr($k,6)))
			{
				$checked[] = (int) substr($k,6);
			}
		}
		
		if(!empty($checked))
		{
			foreach($checked as $clientid)
			{
				$client = frc_get_client_details($clientid);		
				
				// define fields
				$fields = array(
					'_api' => $apicode,
					'_action' => 'query',
				);
				
				// add hashed fields
				foreach($client as $k => $v)
					$fields[$k] = fraudrecord_hash(prepare_value($v));
						
				//open connection
				$ch = curl_init();

				//set the url, number of POST vars, POST data
				curl_setopt($ch,CURLOPT_URL,"https://www.fraudrecord.com/api/");
				curl_setopt($ch,CURLOPT_POST,count($fields));
				curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
				curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);

				//execute post
				$result = curl_exec($ch);

				//close connection
				curl_close($ch);
				
				preg_match("~\<report\>([0-9.\-a-f]+)\</report\>~",$result,$matches);
	
				$result_exp = explode("-",$matches[1]);
				$query_value = $matches[1];
				if(isset($result_exp[3]) && strlen($result_exp[3]) == 16)
				{
					
				
					// is the client in the mod_fraudrecord already?
					$result = $pdo->query("
					SELECT MIN(ID_FRC) as minid
					FROM mod_fraudrecord
					WHERE ID_CLIENT = $clientid");
					$minid = $result->fetch(PDO::FETCH_ASSOC);
					
					$minid = $minid['minid'];
					
					if(!empty($minid))
					{
						
						$update = array(
							"query_value"=>$query_value,
							"query_time" => time(),
						);
						
						Capsule::table("mod_fraudrecord")->where("ID_FRC", $minid)->update($update);
					}
					else
					{
						$insert = array(
							'ID_CLIENT' => $clientid,
							"query_value"=>$query_value,
							"query_time" => time(),
						);
						Capsule::table("mod_fraudrecord")->insert($insert);
					}
				}
			}
			
			$status = "successquery";					
		}
	}
	
	if(empty($action) || $action == "list")
	{
		$action = 'list';
		$display = 'list';
		
		if(isset($_POST['search_frc_button']) && !empty($_POST['search_frc_text']))
		{
			$search = $_POST['search_frc_text'];
		}
		// get perpage from general config
		$result = $pdo->query("
		SELECT value
		FROM tblconfiguration
		WHERE setting = 'NumRecordstoDisplay'");
		$perpage = $result->fetch(PDO::FETCH_ASSOC);
		
		$perpage = $perpage['value'];
		
		if(!ctype_digit($perpage) || empty($perpage))
			$perpage = 50;
		
		// navigation pages for list
		$page = (int) $_REQUEST['page'];
		if(empty($page) || $page < 1)
			$page = 1;
		
		// get client count
		if(isset($search)) {
			$statement = $pdo->prepare("
			SELECT COUNT(id) as client_count
			FROM tblclients
				WHERE
					firstname LIKE concat('%', ?, '%')
					OR lastname LIKE concat('%', ?, '%')
					OR email LIKE concat('%', ?, '%')
				"
			);
			$statement->execute(array($search,$search,$search));
			
		}
		else {
			$statement = $pdo->prepare("
			SELECT COUNT(id) as client_count
			FROM tblclients"
			);
			$statement->execute();
		}
	
		$clientcount = $statement->fetch(PDO::FETCH_ASSOC);
		$clientcount = $clientcount['client_count'];
		
				
		// get client list
		if(isset($search)) {
			$statement = $pdo->prepare("
			SELECT id, firstname, lastname, email, address1, address2, phonenumber, cardnum, ip, datecreated
		FROM tblclients
				WHERE
					firstname LIKE concat('%', ?, '%')
					OR lastname LIKE concat('%', ?, '%')
					OR email LIKE concat('%', ?, '%')
				ORDER BY id DESC
			LIMIT ".(($page-1)*$perpage).",".($perpage).""
			);
			$statement->execute(array($search,$search,$search));
			
		}
		else {
			$statement = $pdo->prepare("
			SELECT id, firstname, lastname, email, address1, address2, phonenumber, cardnum, ip, datecreated
		FROM tblclients
		ORDER BY id DESC
		LIMIT ".(($page-1)*$perpage).",".($perpage).""
			);
			$statement->execute();
		}
		
		
		$list = array();
		while($row = $statement->fetch(PDO::FETCH_ASSOC))
		{
			$list[$row['id']] = $row;			
		}
		
		if(!empty($list)) {
			
			// get their fraud records
			$result = $pdo->query("
			SELECT ID_CLIENT, report_value, report_time, query_value, query_time
			FROM mod_fraudrecord
			WHERE ID_CLIENT IN ('" . implode("','", array_keys($list)) . "')
			");
			
			while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
				if (empty($list[$row['ID_CLIENT']]['report_value'])) {
					$list[$row['ID_CLIENT']]['report_value'] = 0;
				}
				
				$list[$row['ID_CLIENT']]['report_value'] += $row["report_value"];
				$list[$row['ID_CLIENT']]['report_time'] += $row["report_time"];
				
				if (!empty($row['query_value'])) {
					$list[$row['ID_CLIENT']]['query_value'] = $row['query_value'];
					$list[$row['ID_CLIENT']]['query_time'] = $row['query_time'];
				}
			}
		}
		
	}
	
	$alert = frc_updatealert($apicode);
    include(dirname(__FILE__)."/fraudrecord_template.php");

}

function frc_updatealert($apicode)
{
	/**
	 * @var PDO $pdo
	 */
	$pdo = Capsule::connection()->getPdo();
	
	$result = $pdo->query("SELECT report_data
		FROM mod_fraudrecord WHERE ID_FRC = 1");
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if(empty($row))
		$pdo->query("INSERT INTO mod_fraudrecord (ID_FRC, ID_CLIENT) VALUES (1,0)");
		
	$row = @unserialize(@base64_decode($row['report_data']));
	
	if((isset($row['time']) && $row['time'] < time() - 86400/2) || !isset($row['time']))
	{
		// update
		// define fields
		$fields = array(
			'_api' => $apicode,
		);
		
		//open connection
		$ch = curl_init();

		//set the url, number of POST vars, POST data
		curl_setopt($ch,CURLOPT_URL,"https://www.fraudrecord.com/alerts.php");
		curl_setopt($ch,CURLOPT_POST,count($fields));
		curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);

		//execute post
		$result = curl_exec($ch);

		//close connection
		curl_close($ch);
		
		preg_match("~\<alert\>(.+)\</alert\>~",$result,$matches);
		
		$matches = @unserialize(@base64_decode($matches[1]));
		
		if(isset($matches['content']))
		{
			$alert = $matches;
			$alert['time'] = time();
			$statement = $pdo->prepare("UPDATE mod_fraudrecord
			SET report_data = ?
			WHERE ID_FRC = 1");
			$statement->execute(array(base64_encode(serialize($alert))));
			
		}
	}
	elseif(isset($row['time']))
	{
		$alert = array(
			'type' => $row['type'],
			'title' => $row['title'],
			'content' => $row['content'],
			'link' => $row['link'],
			'linktext' => $row['linktext'],
		);
	}
	
	if(!empty($alert))
		return $alert;
	else
		return false;
}

function frc_get_client_details($clientid)
{
	global $cc_encryption_hash;
	
	/**
	 * @var PDO $pdo
	 */
	$pdo = Capsule::connection()->getPdo();
	
	$hash = md5($cc_encryption_hash.$clientid);
	
	$clientid = (int) $clientid;
	$result = $pdo->query("SELECT firstname,lastname,email,phonenumber,address1,address2,city,state,ip,
		cardnum, AES_DECRYPT(cardnum, '$hash') AS ccnumber
		FROM tblclients WHERE id = $clientid");
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	
	if(!empty($row))
	{
		
		// get regular data
		$client = array(
			'name' => $row['firstname']. ' '. $row['lastname'],
			'email' => $row['email'],
			'phonenumber' => $row['phonenumber'],
			'address' => $row['address1'].' '.$row['address2'].' '.$row['city'].' '.$row['state'],
			'ip' => $row['ip'],			
		);
		// if there is a cc number
		if(!empty($row['cardnum']))
			$client['ccnumber'] = $row['ccnumber'];
		
		// delete empty fields, e.g phone number
		foreach($client as $k => $v)
		{
			if(empty($v))
				unset($client[$k]);
		}
	
		return $client;
	}
	else 
		return false;
}

function prepare_value($val)
{
	$value = strtolower(str_replace(" ","",trim($val)));
	
	// for @gmail.com, ignore username after plus sign
	if(strpos($value,"@gmail.com") !== false)
	{
		$email = substr($value,0,strrpos($value,"@gmail.com"));
		if(strpos($value,"+") !== false)
			$email = substr($value,0,strpos($value,"+"));
		
		$value = str_replace(".","",$email)."@gmail.com";
	}
	return $value;
}
function fraudrecord_hash($value) {
    for($i = 0; $i < 32000; $i++)
        $value = sha1("fraudrecord-".$value);
    return $value;
}
?>